<?php
header('Content-Type: application/json; charset=utf-8');
include 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $data = json_decode(file_get_contents("php://input"), true);
    if (!is_array($data)) $data = $_POST;

    if (empty($data["Notice"]) && empty($data["ScrollNotice"])) {
        echo json_encode([
            "status" => "error",
            "message" => "Notice or ScrollNotice value required"
        ]);
        exit;
    }

    $Notice        = trim($data["Notice"] ?? "");
    $ScrollNotice  = trim($data["ScrollNotice"] ?? "");

    $sql = "INSERT INTO `notice` (`id`, `Notice`, `ScrollNotice`)
            VALUES (1, ?, ?)
            ON DUPLICATE KEY UPDATE
                `Notice` = VALUES(`Notice`),
                `ScrollNotice` = VALUES(`ScrollNotice`),
                `created_at` = CURRENT_TIMESTAMP";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $Notice, $ScrollNotice);

    if ($stmt->execute()) {
        echo json_encode([
            "status" => "success",
            "message" => "Notice updated successfully"
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Save failed"
        ]);
    }

    $stmt->close();
}
else if ($_SERVER['REQUEST_METHOD'] === 'GET') {

    $result = $conn->query("SELECT * FROM `notice` WHERE `id` = 1 LIMIT 1");

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo json_encode([
            "status"        => "success",
            "Notice"        => $row["Notice"],
            "ScrollNotice"  => $row["ScrollNotice"]
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "No data found"
        ]);
    }
}

$conn->close();
?>